# NECOCLAW Changelog

All notable changes to NECOCLAW are documented here.

Format: [Semantic Versioning](https://semver.org/) — `MAJOR.MINOR.PATCH`

---

## [0.3.0] - 2026-03-05

### Added
- **Version Info Page** — New "版本信息" sidebar page with two tabs
  - Version Info: version number, system info, tool/skill counts, full changelog
  - Blog: embedded damai.me blog iframe for in-app reading
  - **Backup & Restore panel** (prominent, top of page): one-click backup, dropdown restore, download, delete
  - **Working Directories**: shows data dir, workspace, memory DB, skills, backups, config file paths
- **HTTP Request Tool** — `http_request` for NECO to make POST/PUT/DELETE with custom headers
- **Task Scheduler Enhancements** — Log button, AI Tune button, sort & filter
- **First-Run Welcome Greeting** — Random welcome messages on first WebUI visit
- **Idle Greeting Threshold** — Changed from 10 min to 60 min for proactive work reports

### Fixed
- Backup auto-prune (max 10), ZIP integrity validation, auto-reload after restore
- Channel management: gateway ID validation, toast notifications, sanitized errors

### Changed
- Version bumped: 0.2.2 → 0.3.0

---

## [0.2.3] - 2026-03-05

### Added
- **HTTP Request Tool** — `http_request` tool for NECO to make POST/PUT/DELETE requests with custom headers
  - Supports Authorization headers, JSON body, all HTTP methods
  - Enables NECO to interact with external APIs (blog publishing, webhooks, etc.)
- **Task Scheduler Enhancements** — Real-time log & AI fine-tune controls
  - "Log" button shows task execution history, run results, and errors
  - "Tune" button allows inline editing of task name, schedule, description, and prompt
  - Sort tasks by: creation date, name, run count, last run time
  - Filter tasks by status: active, paused, stopped, trial
- **Version Info Page** — New sidebar navigation item with two sub-tabs
  - "Version Info" tab: displays current version, OS, Go version, LLM engine, tool/skill counts, full changelog
  - "Blog" tab: embedded damai.me blog via iframe for in-app reading
- **First-Run Welcome Greeting** — Random welcome messages on first WebUI visit
  - Three randomized Chinese greetings with setup instructions
  - Links to quickstart documentation
- **Idle Greeting Threshold** — Changed from 10 minutes to 60 minutes for proactive work reports

### Fixed
- **Backup & Restore** — Multiple improvements:
  - Auto-prune: keeps only latest 10 backups, deletes oldest automatically
  - ZIP integrity validation before restore (checks for config.yaml)
  - Auto-reload page after successful restore
  - Toast notifications instead of raw alert() popups
  - English response messages (removed hardcoded Chinese)
- **Channel Management** — Security and UX fixes:
  - Gateway ID validation against known set (prevents invalid channel configs)
  - Toast notifications for save success/failure instead of alert()
  - Sanitized error messages (no raw stack traces)

### Changed
- Version bumped: 0.2.2 → 0.2.3
- Task update API: PATCH with "update" action for inline task editing
- Backup restore message: i18n-friendly English text

---

## [0.2.2] - 2026-03-06

### Fixed
- **Memory System Critical Fix** — NECO now remembers owner instructions across chats
  - Distiller prompt enhanced: owner directives and API configs extracted at importance ≥ 0.9
  - New `directives` field in DistilledMemory for double-retention of critical instructions
  - Immediate triple extraction: high-importance episodes (≥0.8) trigger knowledge graph updates instantly instead of waiting for nightly consolidation
  - System/scheduled tasks now access long-term memory via `ActiveRecallForSystemTask` (global search, not limited by ChatID)
  - Scheduled task system prompt now includes recalled memories (configs, tokens, directives)
- Token leak incident: rotated compromised token, removed sensitive data from public blog post

### Changed
- `distiller.go`: Enhanced distillation prompt with owner-directive priority rules
- `episodic.go`: Added `OnEpisodeCreated` callback for real-time triple extraction
- `consolidation.go`: New `ExtractFromEpisodeImmediate()` public method
- `manager.go`: New `ActiveRecallForSystemTask()` method for global config memory retrieval
- `agent.go`: System tasks no longer skip ActiveRecall; memory context injected into lightweight prompt
- `auto_novel.json` skill: enabled + token updated
- DistilledMemory MaxTokens: 500 → 800
- Version bumped: 0.2.1 → 0.2.2

---

## [0.2.1] - 2026-03-04

### Added
- **Backup & Restore** — Full data backup and restore from WebUI Dashboard
  - Create ZIP backups of config, memory, providers, skills, genetic data, and chat sessions
  - One-click restore from any backup point
  - Download backups locally for safekeeping
  - Delete old backups from the management UI
  - i18n support (English + Chinese + 10 other languages)

### Fixed
- Brand references: replaced legacy `mniai` references with `necoclaw` in 3 source files
- WebUI documentation page now includes 9 annotated screenshots

### Changed
- Version bumped: 0.2.0 → 0.2.1

---

## [0.2.0] - 2026-03-04

### Added
- **Office Document Read & Write** — Full support for reading and writing common office formats
  - Read: `.docx`, `.doc`, `.xlsx`, `.xls`, `.pptx`, `.pdf`
  - Write: `.docx` (with headings/bold/bullets), `.xlsx` (styled headers), `.pptx` (slides), `.csv` (UTF-8 BOM)
  - `write_file` tool auto-detects document extensions and generates proper binary format
  - `read_file` tool auto-extracts text from all supported document formats
  - New builtin skill: `builtin-document-office` — teaches Neco document workflows
- **Data Integrity System** — Prevents data loss during updates
  - `BackupData()` now backs up ALL critical files (12 files + 3 directories)
  - `DataIntegrityCheck()` auto-restores missing files from backup on startup
  - Data directory marker persisted to 2 locations (binary dir + `~/.necoclaw/`)
  - `NECOCLAW_DATA_DIR` environment variable support for explicit data path
- **Scheduler Starvation Fix** — All scheduled tasks now execute reliably
  - Concurrent goroutine-per-task execution with dedup guard
  - No more starvation of tasks at end of queue
- **Market Session Detection** — Stock tracker uses correct price fields per session
  - Pre-market, regular, after-hours, closed session detection
  - Conditional data fetching to avoid stale data
- **macOS ARM64 Build** — Apple Silicon native binary (M1/M2/M3/M4)
- **CHANGELOG.md** — Version history tracking for all releases

### Fixed
- Chinese encoding corruption in scheduled tasks created from Windows terminal
- A股选股 group API "invalid JSON" caused by garbled curl body
- Stock data always showing stale prices during off-market hours
- LLM Router routes not surviving restart (provider_store.go merge priority)
- Embedding API 404 (chromem-go URL missing `/api` suffix)
- Legacy `.doc` files not readable (added OLE2 binary extraction)

### Changed
- `BackupData()` scope: 3 files + 2 dirs → 12 files + 3 dirs
- `read_file` tool description updated with full format list
- `write_file` tool description updated with document writing instructions
- Skills count: 72 → 73 (added builtin-document-office)
- Version bumped: 0.1.0 → 0.2.0

---

## [0.1.0] - 2026-03-01

### Added
- Initial release of NECOCLAW
- Multi-gateway support: WebUI, Feishu, Telegram, Discord, DingTalk, Slack, WeChat, QQ
- LLM Router with multi-provider support and daily quotas
- Memory system: SQLite + vector store (Ollama embeddings)
- Skills system: builtin skills + user-created skills + Skill Hubs
- Task scheduler with instant and scheduled tasks
- Desktop automation (TuriX-CUA): screen capture, mouse/keyboard control
- Self-update system via SOFT distribution service
- Project sandbox with multi-runtime support
- Evolution system: tiers, growth tracking, genome
- Security system: file guard, prompt guard
- Contact/Group management with multi-persona chat
- Reach search: web, GitHub, arXiv multi-channel search
- EQ (Emotional Intelligence) engine
