@echo off
chcp 65001 >nul 2>&1
title NECOCLAW Installer

echo.
echo   /\_/\
echo  ( o.o )
echo   ^> ^^ ^<
echo.
echo  NECOCLAW Installer v0.1.0
echo  ─────────────────────────
echo.

set "INSTALL_DIR=%USERPROFILE%\.necoclaw"
set "SCRIPT_DIR=%~dp0"

:: Create install directory
if not exist "%INSTALL_DIR%" (
    echo [1/5] Creating %INSTALL_DIR% ...
    mkdir "%INSTALL_DIR%"
) else (
    echo [1/5] %INSTALL_DIR% already exists, OK.
)

:: Copy binary
echo [2/5] Copying necoclaw.exe ...
copy /Y "%SCRIPT_DIR%necoclaw.exe" "%INSTALL_DIR%\necoclaw.exe" >nul
if errorlevel 1 (
    echo ERROR: Failed to copy necoclaw.exe
    echo Make sure necoclaw.exe is in the same folder as this script.
    pause
    exit /b 1
)

:: Copy config template if not exists
if not exist "%INSTALL_DIR%\config.yaml" (
    echo [3/5] Creating default config.yaml ...
    if exist "%SCRIPT_DIR%config.yaml" (
        copy /Y "%SCRIPT_DIR%config.yaml" "%INSTALL_DIR%\config.yaml" >nul
    ) else if exist "%SCRIPT_DIR%config.yaml.example" (
        copy /Y "%SCRIPT_DIR%config.yaml.example" "%INSTALL_DIR%\config.yaml" >nul
    ) else (
        echo WARNING: No config template found. You can configure later via WebUI.
    )
) else (
    echo [3/5] config.yaml already exists, keeping your settings.
)

:: Add to PATH
echo [4/5] Adding to PATH ...
echo %PATH% | findstr /I /C:"%INSTALL_DIR%" >nul
if errorlevel 1 (
    setx PATH "%PATH%;%INSTALL_DIR%" >nul 2>&1
    if errorlevel 1 (
        echo WARNING: Could not add to PATH automatically.
        echo Please add %INSTALL_DIR% to your PATH manually.
    ) else (
        echo Added %INSTALL_DIR% to PATH.
        echo NOTE: Open a NEW terminal for PATH to take effect.
    )
) else (
    echo Already in PATH, OK.
)

:: Run doctor
echo [5/5] Running diagnostics ...
echo.
"%INSTALL_DIR%\necoclaw.exe" doctor
echo.

echo ─────────────────────────────────────────
echo  Installation complete!
echo.
echo  To start NECOCLAW:
echo    1. Open a NEW terminal (cmd or PowerShell)
echo    2. Run: necoclaw start
echo    3. Open browser: http://localhost:24088
echo.
echo  Or double-click start.bat in this folder.
echo ─────────────────────────────────────────
echo.
pause
